// GxtY6011.cpp: implementation of the CGxtY601 class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GxtY601.h"
#include "GxtY_601.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern int g_nSerialNum;
extern int g_nModeClosePort;

CRITICAL_SECTION	m_csBuf;
CRITICAL_SECTION	m_csCmdQueue;

//кڵ2ֽ
#define ID_SERIAL_NUM		1

//λ --- 56 00 26 00
// --- 76 00 26 00
BYTE cByteReset[] = 
{
	0x56,
	0x00,
	0x26,
	0x00,
}; 

BYTE cByteRetReset[] = 
{
	0x76,
	0x00,
	0x26,
	0x00,
}; 


// --- 56 00 36 01 00
// --- 76 00 36 00 00
BYTE cBytePhoto[] = 
{
	0x56,
	0x00,
	0x36,
	0x01,
	0x00,
}; 

BYTE cByteRetPhoto[] = 
{
	0x76,
	0x00,
	0x36,
	0x00,
	0x00,
}; 

// --- 56 00 34 01 00 
//   --- 76 00 34 00 04 xx xx xx xx
BYTE cByteReadLength[] = 
{
	0x56,
	0x00,
	0x34,
	0x01,
	0x00,
}; 

BYTE cByteRetReadLength[] = 
{
	0x76,
	0x00,
	0x34,
	0x00,
	0x04,
	0x00, //ȸֽ
	0x00, //
	0x00, //
	0x00, //ȵֽ
}; 

//buf  --- 56 00 32 0C 00 0A 00 00 MM MM 00 00 KK KK XX XX 
//   --- 76 00 34 00 04 xx xx xx xx
BYTE cByteReadBuf[] = 
{
	0x56,
	0x00,
	0x32,
	0x0C,
	0x00,
	0x0A,

	0x00,
	0x00,
	0x00,
	0x00,

	0x00,
	0x00,
	0x00,
	0x00,

	0x00,
	0x00,
}; 

//ֹͣ --- 56 00 36 01 03
//	   --- 76 00 36 00 00
BYTE cByteStopPhoto[] = 
{
	0x56,
	0x00,
	0x36,
	0x01,
	0x03,
}; 

BYTE cByteRetStopPhoto[] = 
{
	0x76,
	0x00,
	0x36,
	0x00,
	0x00,
}; 

//ϵ 
const BYTE cByteRetOnPower[] = 
{
// 0x56,
// 0x43,
// 0x30, 
// 0x37,
// 0x30, 
// 0x33, 
// 0x20, 
// 0x31, 
// 0x2E, 
// 0x30, 
// 0x30, 
// 0x0D, 
// 0x0A, 
// 0x43, 
// 0x74, 
// 0x72, 
// 0x6C, 
// 0x20, 
// 0x69, 
// 0x6E, 
// 0x66, 
// 0x72, 
// 0x20, 
// 0x65, 
// 0x78, 
// 0x69, 
// 0x73, 
// 0x74, 
// 0x0D, 
// 0x0A, 
// 0x55, 
// 0x73, 
// 0x65, 
// 0x72, 
// 0x2D,
// 0x64, 
// 0x65, 
// 0x66, 
// 0x69, 
// 0x6E, 
// 0x65, 
// 0x64, 
// 0x20, 
// 0x73, 
// 0x65, 
// 0x6E, 
// 0x73, 
// 0x6F, 
// 0x72, 
// 0x0D, 
// 0x0A, 
// 0x36, 
// 0x32, 
// 0x35, 
// 0x0D, 
// 0x0A, 
0x49, 
0x6E, 
0x69, 
0x74, 
0x20, 
0x65, 
0x6E, 
0x64, 
0x0D, 
0x0A, 
}; 

const int nSizeRetOnPower = sizeof(cByteRetOnPower) / sizeof(BYTE);

//ͼС(160*120) --- 56 00 31 05 04 01 00 19 22
//			    --- 76 00 31 00 00
BYTE cByteImageSize160x120[] = 
{
	0x56,
	0x00,
	0x31,
	0x05,
	0x04,
	0x01,
	0x00,
	0x19,
	0x22,
}; 

BYTE cByteRetImageSize160x120[] = 
{
	0x76,
	0x00,
	0x31,
	0x00,
	0x00,
}; 


//ͼС(320*240) --- 56 00 31 05 04 01 00 19 11
//			    --- 76 00 31 00 00
BYTE cByteImageSize320x240[] = 
{
	0x56,
	0x00,
	0x31,
	0x05,
	0x04,
	0x01,
	0x00,
	0x19,
	0x11,
}; 

BYTE cByteRetImageSize320x240[] = 
{
	0x76,
	0x00,
	0x31,
	0x00,
	0x00,
}; 


//ͼС(640*480) --- 56 00 31 05 04 01 00 19 00
//			    --- 76 00 31 00 00
//ע: Ҫλ
BYTE cByteImageSize640x480[] = 
{
	0x56,
	0x00,
	0x31,
	0x05,
	0x04,
	0x01,
	0x00,
	0x19,
	0x00,
}; 

BYTE cByteRetImageSize640x480[] = 
{
	0x76,
	0x00,
	0x31,
	0x00,
	0x00,
}; 

//ʡ --- 56 00 3E 03 00 01 01
// --- 76 00 3E 00 00
BYTE cByteSavePower[] = 
{
	0x56,
	0x00,
	0x3E,
	0x03,
	0x00,
	0x01,
	0x01,
}; 

BYTE cByteRetSavePower[] = 
{
	0x76,
	0x00,
	0x3E,
	0x00,
	0x00,
}; 

//˳ʡ --- 56 00 3E 03 00 01 00
//	   --- 76 00 3E 00 00
BYTE cByteExitSavePower[] = 
{
	0x56,
	0x00,
	0x3E,
	0x03,
	0x00,
	0x01,
	0x00,
}; 

BYTE cByteRetExitSavePower[] = 
{
	0x76,
	0x00,
	0x3E,
	0x00,
	0x00,
}; 

//Ĭϲ
BYTE cByteDefBaud9600[] = 
{
	0x56,
	0x00,
	0x31,
	0x06,
	0x04,
	0x02,
	0x00,
    0x08,
    0xAE,
    0xC8,
};

BYTE cByteDefBaud19200[] = 
{
	0x56,
	0x00,
	0x31,
	0x06,
	0x04,
	0x02,
	0x00,
    0x08,
    0x56,
    0xE4,
};

BYTE cByteDefBaud38400[] = 
{
	0x56,
	0x00,
	0x31,
	0x06,
	0x04,
	0x02,
	0x00,
    0x08,
    0x2A,
    0xF2,
};

BYTE cByteDefBaud57600[] = 
{
	0x56,
	0x00,
	0x31,
	0x06,
	0x04,
	0x02,
	0x00,
    0x08,
    0x1C,
    0x4C,
};

BYTE cByteDefBaud115200[] = 
{
	0x56,
	0x00,
	0x31,
	0x06,
	0x04,
	0x02,
	0x00,
    0x08,
    0x0D,
    0xA6,
};

BYTE cByteRetDefBaud[] = 
{
	0x76,
	0x00,
	0x31,
	0x00,
	0x00,
}; 
//ʱ
BYTE cByteBaud9600[] = 
{
	0x56,
	0x00,
	0x24,
	0x03,
	0x01,
	0xAE,
	0xC8,
}; 

BYTE cByteBaud19200[] = 
{
	0x56,
	0x00,
	0x24,
	0x03,
	0x01,
	0x56,
	0xE4,
}; 

BYTE cByteBaud38400[] = 
{
	0x56,
	0x00,
	0x24,
	0x03,
	0x01,
	0x2A,
	0xF2,
}; 

BYTE cByteBaud57600[] = 
{
	0x56,
	0x00,
	0x24,
	0x03,
	0x01,
	0x1C,
	0x4C,
}; 

BYTE cByteBaud115200[] = 
{
	0x56,
	0x00,
	0x24,
	0x03,
	0x01,
	0x0D,
	0xA6,
}; 

BYTE cByteRetBaud[] = 
{
	0x76,
	0x00,
	0x24,
	0x00,
	0x00,
}; 


//ѹ --- 56 00 31 05 01 01 12 04 XX
//   --- 76 00 31 00 00
BYTE cByteZipRate[] = 
{
	0x56,
	0x00,
	0x31,
	0x05,
	0x01,
	0x01,
	0x12,
	0x04,
	0x00,  //޸ΪӦѹ, Ĭ36 
}; 

BYTE cByteRetZipRate[] = 
{
	0x76,
	0x00,
	0x31,
	0x00,
	0x00,
}; 
//ƶ⴮
BYTE cByteMotionOpen[] = 
{
	0x56,
	0x00,
	0x37,
	0x01,
	0x01,
};
//رƶ⴮
BYTE cByteMotionClose[] = 
{
	0x56,
	0x00,
	0x37,
	0x01,
	0x00,
};

//ƶⷵ
BYTE cByteRetMotion[] = 
{
	0x76,
	0x00,
	0x37,
	0x00,
	0x00,
};

//豸⵽ƶʱʾ
BYTE cByteMotionDetected[] = 
{
	0x76,
	0x00,
	0x39,
	0x00,
	0x00,
};

//Motion ƶ,һֽڱʾ
BYTE cByteMotionSensitivity[] = 
{
	0x56,
	0x00,
	0x31, 
	0x05,
	0x01, 
	0x01, 
	0x1A, 
	0x6E, 
	0x03,
};

BYTE cByteRetMotionSensitivity[] = 
{
	0x76,
	0x00,
	0x31,
	0x00,
	0x00,
};

// 456 00 32 0C 00 0A 00 00 MM MM 00 00 KK KK XX XX
// أ76 00 32 00 00 ʱ䣩   FF D8  ʱ䣩 76 00 32 00 00
// 
// ʱ䣩= XX  XX*001
// MM  MM  MM  MM  ʼַ
// KK  KK   KK   KK     ݳ
// 


// λ
// 
// 


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CGxtY601::CGxtY601(HWND hParent)
{
	m_hParentWnd = hParent;
	pProcessThread = NULL;
	bRun = FALSE;
	
	hEventShut = NULL;

	m_bPortOpen = FALSE;
	m_nMotionStatus = MOTION_NONE_INCOMING;
	
	InitializeCriticalSection(&m_csBuf);
	InitializeCriticalSection(&m_csCmdQueue);
}

CGxtY601::~CGxtY601()
{
	DeleteCriticalSection(&m_csBuf);
	DeleteCriticalSection(&m_csCmdQueue);
}

//ڴ򿪺͹ر
BOOL CGxtY601::OpenPort(CWnd* pPortOwner, UINT portnr, UINT baud, char parity, UINT databits, UINT stopsbits, DWORD dwCommEvents, UINT nBufferSize)
{
	
	BOOL bOpen = FALSE;
	bOpen = m_SerialPort.InitPort(pPortOwner, portnr, baud, parity, databits, stopsbits, dwCommEvents, nBufferSize);
	
	if (bOpen)
	{
		//մ߳
		StartProcessThread();
		m_SerialPort.StartMonitoring();
	}

	m_bPortOpen = bOpen;
	
	m_bStart = TRUE;
	return bOpen;
}

void CGxtY601::ClosePort()
{
	//ȹرմڷ߳
	m_SerialPort.StopMonitoring();
	StopProcessThread();

	//ɾ
	EnterCriticalSection(&m_csBuf);
	m_ArrBuf.RemoveAll();
	LeaveCriticalSection(&m_csBuf);

	m_bPortOpen = FALSE;

	m_bStart = FALSE;
}

BOOL CGxtY601::IsPortOpen()
{
	return m_bPortOpen;
}

//ݷ͵ķװ
void CGxtY601::SendReset()
{
	m_SerialPort.WriteToPort(cByteReset, sizeof(cByteReset)/sizeof(BYTE));
}

void CGxtY601::SendPhoto()
{
//	AfxMessageBox("");
	m_SerialPort.WriteToPort(cBytePhoto, sizeof(cBytePhoto)/sizeof(BYTE));	
}

void CGxtY601::SendReadLength()
{
	m_SerialPort.WriteToPort(cByteReadLength, sizeof(cByteReadLength)/sizeof(BYTE));		
}

void CGxtY601::SendReadBuf(DWORD dwStartAddr, DWORD dwLength, UINT nInterval/* = 255*/)
{
	//3~0Ӹλλ
	BYTE byStartAddr[4];
	BYTE byLength[4];
	BYTE byInterval[2];

	byStartAddr[3] = (BYTE)(dwStartAddr / 0x1000000);
	byStartAddr[2] = (BYTE)((dwStartAddr % 0x1000000) / 0x10000);
	byStartAddr[1] = (BYTE)(((dwStartAddr % 0x1000000) % 0x10000) / 0x100);
	byStartAddr[0] = (BYTE)(((dwStartAddr % 0x1000000) % 0x10000) % 0x100);
	
	byLength[3] = (BYTE)(dwLength / 0x1000000);
	byLength[2] = (BYTE)((dwLength % 0x1000000) / 0x10000);
	byLength[1] = (BYTE)(((dwLength % 0x1000000) % 0x10000) / 0x100);
	byLength[0] = (BYTE)(((dwLength % 0x1000000) % 0x10000) % 0x100);
	
	byInterval[1] = (BYTE)(nInterval / 0x100);
	byInterval[0] = (BYTE)(nInterval % 0x100);

	int nSize = sizeof(cByteReadBuf)/sizeof(BYTE);
	
	//ٶ˴Э鳤Ȳᳬ20
	ASSERT(nSize < 20);
	
	BYTE byReadBuf[20];
	memset(byReadBuf, 0, 20);
	memcpy(byReadBuf, cByteReadBuf, nSize);
/*	
	const BYTE cByteReadBuf[] = 
	{
		0x56,
		0x00,
		0x32,
		0x0C,
		0x00,
		0x0A,
		
		0x00,
		0x00,
		0x00,
		0x00,
		
		0x00,
		0x00,
		0x00,
		0x00,
		
		0x00,
		0x00,
	}; 
*/
	byReadBuf[6] = byStartAddr[3];
	byReadBuf[7] = byStartAddr[2];
	byReadBuf[8] = byStartAddr[1];
	byReadBuf[9] = byStartAddr[0];
	
	byReadBuf[10] = byLength[3];
	byReadBuf[11] = byLength[2];
	byReadBuf[12] = byLength[1];
	byReadBuf[13] = byLength[0];

	byReadBuf[14] = byInterval[1];
	byReadBuf[15] = byInterval[0];
	
	
	m_SerialPort.WriteToPort(byReadBuf, nSize);

}

void CGxtY601::SendStopPhoto()
{
//	AfxMessageBox("ֹͣ");
	
	m_SerialPort.WriteToPort(cByteStopPhoto, sizeof(cByteStopPhoto)/sizeof(BYTE));			
}

void CGxtY601::SendSetZipRate(int nZipRate)
{
	int nSize = sizeof(cByteZipRate)/sizeof(BYTE);

	//ٶ˴Э鳤Ȳᳬ20
	ASSERT(nSize < 20);

	BYTE byZipRate[20];
	memset(byZipRate, 0, 20);
	memcpy(byZipRate, cByteZipRate, nSize);

	byZipRate[nSize-1] = nZipRate;
	
	
	m_SerialPort.WriteToPort(byZipRate, nSize);
}

void CGxtY601::SendImageSize(int nModeImageSize)
{
    if (nModeImageSize == MODE_IMAGE_SIZE_160X120)
	{
		m_SerialPort.WriteToPort(cByteImageSize160x120, sizeof(cByteImageSize160x120)/sizeof(BYTE));
	}
	else if (nModeImageSize == MODE_IMAGE_SIZE_320X240)
	{
		m_SerialPort.WriteToPort(cByteImageSize320x240, sizeof(cByteImageSize320x240)/sizeof(BYTE));
	}
	else if (nModeImageSize == MODE_IMAGE_SIZE_640X480)
	{
		m_SerialPort.WriteToPort(cByteImageSize640x480, sizeof(cByteImageSize640x480)/sizeof(BYTE));
	}
	else
	{
		ASSERT(FALSE);
	}
}

void CGxtY601::SendSavePower(int nModePower)
{
	if (nModePower == MODE_SAVE_POWER)
	{
		m_SerialPort.WriteToPort(cByteSavePower, sizeof(cByteSavePower)/sizeof(BYTE));
	}
	else if (nModePower == MODE_EXIT_SAVE_POWER)
	{
		m_SerialPort.WriteToPort(cByteExitSavePower, sizeof(cByteExitSavePower)/sizeof(BYTE));
	}
	else
	{
		ASSERT(FALSE);
	}	
}

void CGxtY601::SendDefBaud(UINT nDefBaud)
{
	
	if (nDefBaud == 9600)
	{
		m_SerialPort.WriteToPort(cByteDefBaud9600, sizeof(cByteDefBaud9600)/sizeof(BYTE));
	}
	else if (nDefBaud == 19200)
	{
		m_SerialPort.WriteToPort(cByteDefBaud19200, sizeof(cByteDefBaud19200)/sizeof(BYTE));
	}
	else if (nDefBaud == 38400)
	{
		m_SerialPort.WriteToPort(cByteDefBaud38400, sizeof(cByteDefBaud38400)/sizeof(BYTE));
	}
	else if (nDefBaud == 57600)
	{
		m_SerialPort.WriteToPort(cByteDefBaud57600, sizeof(cByteDefBaud57600)/sizeof(BYTE));
	}
	else if (nDefBaud == 115200)
	{
		m_SerialPort.WriteToPort(cByteDefBaud115200, sizeof(cByteDefBaud115200)/sizeof(BYTE));
	}
	else
	{
		ASSERT(FALSE);
	}
}

void CGxtY601::SendBaud(UINT nBaud)
{
	
	if (nBaud == 9600)
	{
		m_SerialPort.WriteToPort(cByteBaud9600, sizeof(cByteBaud9600)/sizeof(BYTE));
	}
	else if (nBaud == 19200)
	{
		m_SerialPort.WriteToPort(cByteBaud19200, sizeof(cByteBaud19200)/sizeof(BYTE));
	}
	else if (nBaud == 38400)
	{
		m_SerialPort.WriteToPort(cByteBaud38400, sizeof(cByteBaud38400)/sizeof(BYTE));
	}
	else if (nBaud == 57600)
	{
		m_SerialPort.WriteToPort(cByteBaud57600, sizeof(cByteBaud57600)/sizeof(BYTE));
	}
	else if (nBaud == 115200)
	{
		m_SerialPort.WriteToPort(cByteBaud115200, sizeof(cByteBaud115200)/sizeof(BYTE));
	}
	else
	{
		ASSERT(FALSE);
	}
}

void CGxtY601::SendMotion(UINT nSwitch)
{
	if (nSwitch == OPEN_MOTION)
	{
		m_SerialPort.WriteToPort(cByteMotionOpen, sizeof(cByteMotionOpen)/sizeof(BYTE));
	}
	else if (nSwitch == CLOSE_MOTION)
	{
		m_SerialPort.WriteToPort(cByteMotionClose, sizeof(cByteMotionClose)/sizeof(BYTE));
	}
	else if (nSwitch == CONFIG_MOTION_SENSITIVITY)
	{
		m_SerialPort.WriteToPort(cByteMotionSensitivity, sizeof(cByteMotionSensitivity)/sizeof(BYTE));
	}
	else
	{
		ASSERT(FALSE);
	}	
}


void CGxtY601::AddSerData(BYTE *pData, WORD wLen)
{
	ASSERT(wLen == 1);

	EnterCriticalSection(&m_csBuf);
	m_ArrBuf.Add(*pData);
	LeaveCriticalSection(&m_csBuf);

//	m_ArrBufDebug.Add(*pData);
}



int CGxtY601::StartProcessThread()
{

	int nRet = 0;

	
	m_bIsWritingBuf = FALSE;
	m_bFirstFrame = FALSE;

	ASSERT(pProcessThread == NULL);
	ASSERT(bRun == FALSE);


	// create or reset event handle
	if (hEventShut == NULL)
	{
		hEventShut = CreateEvent(NULL, TRUE, FALSE, NULL);
	}
	else
	{
		ResetEvent(hEventShut);
	}

	pProcessThread = AfxBeginThread(RecvBufProc, this, THREAD_PRIORITY_NORMAL);

	if (pProcessThread == NULL)
	{
		nRet = 1;
		goto ERROR_DAQPROC;
	}


	return nRet;

ERROR_DAQPROC:
	return nRet;
}

int CGxtY601::StopProcessThread()
{
	int nRet = 0;
	int nTimes = 0;

	while((pProcessThread != NULL)&&(bRun))
	{
		SetEvent(hEventShut);
		Sleep(20);

		nTimes += 1;
		if (nTimes >= 50)
		{
			DWORD dwExitCode;
			BOOL  bThreadStatus;
            bThreadStatus = GetExitCodeThread(pProcessThread->m_hThread, &dwExitCode);
            if ((dwExitCode== (DWORD)STILL_ACTIVE) && (bThreadStatus))
            {
				TerminateThread(pProcessThread->m_hThread, 100);
//				CloseHandle(pDaqThread->m_hThread);

				::PostMessage(m_hParentWnd, UM_PROCESS_THREAD, (WPARAM)0, (LPARAM)THREAD_FORCE_EXIT);
			}
			else
			{
				::PostMessage(m_hParentWnd, UM_PROCESS_THREAD, (WPARAM)0, (LPARAM)THREAD_NORMAL_EXIT);
			}
			
			break;
		}
	}

	pProcessThread = NULL;
	return nRet;
}

UINT CGxtY601::RecvBufProc(LPVOID lParam)
{
	UINT nRet = 0;
	CGxtY601 *pGxtY601;
	BOOL  bExit;

	pGxtY601 = (CGxtY601 *)lParam;


	pGxtY601->bRun = TRUE;
	
	TRACE("RecvBufProc is started\n");
	
	bExit = FALSE;

	while(!bExit)
	{

		if (WaitForSingleObject(pGxtY601->hEventShut, 0) == WAIT_OBJECT_0)
		{
			bExit = TRUE;
			nRet = 2;			// manual terminate
			break;
		}

		//ִѯ
		pGxtY601->OnRevSerData();

		Sleep(TIME_OUT_PROCESS);
		
	} // end while


	pGxtY601->bRun = FALSE;

	TRACE("RecvBufProc is ended with code %d\n", nRet);

	AfxEndThread(nRet);

	return nRet;
}


void CGxtY601::OnRevSerData()
{

	//ҪĽֵ
	//1.ͼƬĳ
	//2.ͼƬ

	int nCmd = CMD_INVALID;
	nCmd = QueryCmd();

	EnterCriticalSection(&m_csBuf);
	if (nCmd != CMD_INVALID)
	{
		CString strMsg;
		strMsg.Format("CMD = %d\r\n", nCmd);

// 		if (nCmd == CMD_STOP_PHOTO || 
// 			nCmd == CMD_READ_BUF_512 ||
// 			nCmd == CMD_READ_BUF_TOTAL)
// 		{
// 			m_pDlg->ReportInfo(strMsg);
// 		}
		
		TRACE(strMsg);

		if (nCmd == CMD_RESET ||
			nCmd == CMD_PHOTO ||
			nCmd == CMD_STOP_PHOTO ||
			nCmd == CMD_READ_LENGTH ||
			nCmd == CMD_ZIP_RATE ||
			nCmd == CMD_SAVE_POWER ||
			nCmd == CMD_EXIT_SAVE_POWER ||
			nCmd == CMD_MODIFY_DefBAUD ||
            nCmd == CMD_MODIFY_BAUD ||
			nCmd == CMD_MODIFY_IMAGE_SIZE ||
			nCmd == CMD_MOTION_OPEN ||
			nCmd == CMD_MOTION_CLOSE ||
			nCmd == CMD_MOTION_SENSITIVITY )
		{
			int nLength = m_ArrBuf.GetSize(); 

			if (nLength <= 0)
			{
				goto ret;
			}

			//֡ͷ־0x76
			BOOL bFind = FALSE;
			int nIndex = -1;
			for (int ii = 0; ii < nLength; ++ii)
			{
				if (m_ArrBuf.GetAt(ii) == 0x76)
				{
					nIndex = ii;
					bFind = TRUE;
					break;
				}
			}
			
			if (bFind)
			{
				if (nIndex > 0)
				{
					m_ArrBuf.RemoveAt(0, nIndex);
				}
			}
			else //ȫ
			{
				//ɾЧ
				//,ٴ!
				m_ArrBuf.RemoveAll();
				goto ret;
			}

			//¼
			nLength = m_ArrBuf.GetSize(); 

			switch (nCmd)
			{
			case CMD_RESET:
				//ٵķֵ4+nSizeRetOnPowerֽ
				if (nLength < 4 + nSizeRetOnPower)
				{
					goto ret;
				}
				
				//ȡǰֽ,Ƚʲôķֵ
				if (m_ArrBuf.GetAt(0) == cByteRetReset[0] &&
					m_ArrBuf.GetAt(1) == cByteRetReset[1] &&
					m_ArrBuf.GetAt(2) == cByteRetReset[2] &&
					m_ArrBuf.GetAt(3) == cByteRetReset[3])
				{
				
					//ж󼸸ֽ49 6E 69 74 20 65 6E 64 0D 0A Ϳ
					BOOL bFind = FALSE;
					int nIndex = -1;
					int ii = 0;
					for (ii = 4; ii < nLength-1; ++ii)
					{
						if (m_ArrBuf.GetAt(ii) == 0x49 && 
							m_ArrBuf.GetAt(ii+1) == 0x6E)
						{
							nIndex = ii-4;
							bFind = TRUE;
							break;
						}
					}
					
					if (bFind)
					{
						if (nIndex > 0)
						{
							m_ArrBuf.RemoveAt(4, nIndex);
						}
					}
					else //ȫ
					{
						//ɾЧ
						//,ٴ!
						m_ArrBuf.RemoveAt(4, nLength-4);
						goto ret;
					}
					
					//¼
					nLength = m_ArrBuf.GetSize(); 
					if (nLength < nSizeRetOnPower)
					{
						goto ret;
					}
					
					//
					DeleteCmd();

					ii = 0;
					//жǷϵ
					for (ii = 0; ii < nSizeRetOnPower; ++ii)
					{
						if (m_ArrBuf.GetAt(4+ii) != cByteRetOnPower[ii])
						{
							break;
						}
					}
					
					if (ii == nSizeRetOnPower)
					{
						m_pDlg->ReportInfo("λɹ!յInit end!");
						m_ArrBuf.RemoveAt(0, 4+nSizeRetOnPower);
						m_nMotionStatus = MOTION_NONE_INCOMING;
						m_pDlg->m_nMotion = 1;
						m_pDlg->SendMessage(WM_MYUPDATEDATA,TRUE);
						
					}
					else
					{
						m_pDlg->ReportInfo("λյδַ֪,սջ!");
						m_ArrBuf.RemoveAll();
					}
					goto ret;
				}
				else
				{

				}
				break;
			case CMD_PHOTO:
				//˸λ,5ֵ
				if (nLength < 5)
				{
					goto ret;
				}
				
				
				if (m_ArrBuf.GetAt(0) == cByteRetPhoto[0] &&
					m_ArrBuf.GetAt(1) == cByteRetPhoto[1] &&
					m_ArrBuf.GetAt(2) == cByteRetPhoto[2] &&
					m_ArrBuf.GetAt(3) == cByteRetPhoto[3] &&
					m_ArrBuf.GetAt(4) == cByteRetPhoto[4])
				{
					//
					DeleteCmd();

//					AfxMessageBox("յճɹ");

					m_ArrBuf.RemoveAt(0, 5);
					m_pDlg->ReportInfo("ճɹ!");
					m_pDlg->DoSendReadLength();
				}		
				break;
			case CMD_STOP_PHOTO:
				if (nLength < 5)
				{
					goto ret;
				}
				
				
				if (m_ArrBuf.GetAt(0) == cByteRetPhoto[0] &&
					m_ArrBuf.GetAt(1) == cByteRetPhoto[1] &&
					m_ArrBuf.GetAt(2) == cByteRetPhoto[2] &&
					m_ArrBuf.GetAt(3) == cByteRetPhoto[3] &&
					m_ArrBuf.GetAt(4) == cByteRetPhoto[4])
				{
				
//					AfxMessageBox("յֹͣճɹ");

					m_pDlg->ReportInfo("ɾֹͣ!");

					//
					DeleteCmd();
					
					m_ArrBuf.RemoveAt(0, 5);
					m_pDlg->ReportInfo("ֹͣճɹ!");
					//m_pDlg->DoNext();

					
					//жǷģʽ

					Sleep(100);

//					AfxMessageBox("ʼһ");

					if(m_nMotionStatus == MOTION_DETECTE_INCOMING)
					{
						AddCmdToQueue(CMD_MOTION_OPEN);
						SendMotion(OPEN_MOTION);
						m_nMotionStatus = MOTION_NONE_INCOMING;
					}
					else
					{
						m_pDlg->PhotoNext();
					}
                    
				}
				//ƶʱԵ
				else if(m_ArrBuf.GetAt(0) == cByteMotionDetected[0] &&
					m_ArrBuf.GetAt(1) == g_nSerialNum &&
					m_ArrBuf.GetAt(2) == cByteMotionDetected[2] &&
					m_ArrBuf.GetAt(3) == cByteMotionDetected[3] &&
					m_ArrBuf.GetAt(4) == cByteMotionDetected[4])
				{
					DeleteCmd();
					
					m_ArrBuf.RemoveAll();

					m_pDlg->ReportInfo("ʱ⵽ƶ!");
				}
				break;
			case CMD_READ_LENGTH:

				
				if (m_ArrBuf.GetAt(0) == cByteRetReadLength[0] &&
					m_ArrBuf.GetAt(1) == cByteRetReadLength[1] &&
					m_ArrBuf.GetAt(2) == cByteRetReadLength[2] &&
					m_ArrBuf.GetAt(3) == cByteRetReadLength[3] &&
					m_ArrBuf.GetAt(4) == cByteRetReadLength[4])
				{
					if (nLength < 9)
					{
						goto ret;
					}
					
					DWORD dwLength = m_ArrBuf.GetAt(5) * 0x1000000 + 
						m_ArrBuf.GetAt(6) * 0x10000 +
						m_ArrBuf.GetAt(7) * 0x100 +
						m_ArrBuf.GetAt(8);
					
					ASSERT(dwLength > 0);
					if (dwLength > 0)
					{
						
						m_dwWriteLen = 0;
						m_dwTotalLen = dwLength;
						
						//
						DeleteCmd();

						m_pDlg->SetFileLength(dwLength);
						
						CString strInfo;
						strInfo.Format("ȡɹ,%ld!", dwLength);
						m_pDlg->ReportInfo(strInfo);
						
						//m_pDlg->DoNext();
						
						//ȴ߳
						//,Ըĳֱ߳,Ϊģʽ
						//Sleep(100);
						//ĳֱ߳
						
						m_pDlg->IndRevJpegData();
                        
					}
					else
					{
						m_pDlg->ReportError("ȡjpgΪ0!");
					}
					
					m_ArrBuf.RemoveAt(0, 9);
					goto ret;
				}
				break;
			case CMD_ZIP_RATE:
				if (nLength < 5)
				{
					goto ret;
				}
				if (m_ArrBuf.GetAt(0) == cByteRetZipRate[0] &&
					m_ArrBuf.GetAt(1) == cByteRetZipRate[1] &&
					m_ArrBuf.GetAt(2) == cByteRetZipRate[2] &&
					m_ArrBuf.GetAt(3) == cByteRetZipRate[3] &&
					m_ArrBuf.GetAt(4) == cByteRetZipRate[4])
				{
					//
					DeleteCmd();

					m_ArrBuf.RemoveAt(0, 5);
					m_pDlg->ReportInfo("ѹʳɹ!");
					goto ret;
				}
				break;
			case CMD_SAVE_POWER:
				if (nLength < 5)
				{
					goto ret;
				}
				if (m_ArrBuf.GetAt(0) == cByteRetSavePower[0] &&
					m_ArrBuf.GetAt(1) == cByteRetSavePower[1] &&
					m_ArrBuf.GetAt(2) == cByteRetSavePower[2] &&
					m_ArrBuf.GetAt(3) == cByteRetSavePower[3] &&
					m_ArrBuf.GetAt(4) == cByteRetSavePower[4])
				{
					//
					DeleteCmd();

					m_ArrBuf.RemoveAt(0, 5);
					m_pDlg->ReportInfo("ıʡģʽɹ!");
					goto ret;
				}
				break;
			case CMD_EXIT_SAVE_POWER:
				if (nLength < 5)
				{
					goto ret;
				}
				if (m_ArrBuf.GetAt(0) == cByteRetSavePower[0] &&
					m_ArrBuf.GetAt(1) == cByteRetSavePower[1] &&
					m_ArrBuf.GetAt(2) == cByteRetSavePower[2] &&
					m_ArrBuf.GetAt(3) == cByteRetSavePower[3] &&
					m_ArrBuf.GetAt(4) == cByteRetSavePower[4])
				{
					//
					DeleteCmd();

					m_ArrBuf.RemoveAt(0, 5);
					m_pDlg->ReportInfo("ıʡģʽɹ!");
					goto ret;
				}
				break;
			case CMD_MODIFY_BAUD:
                if (nLength < 4)
				{
					goto ret;
				}
				if (m_ArrBuf.GetAt(0) == cByteRetBaud[0] &&
					m_ArrBuf.GetAt(1) == cByteRetBaud[1] &&
					m_ArrBuf.GetAt(2) == cByteRetBaud[2] &&
					m_ArrBuf.GetAt(3) == cByteRetBaud[3] )
					
				{
					//
					DeleteCmd();

					m_ArrBuf.RemoveAt(0, 4);
                    m_pDlg->ReportInfo("ʱʳɹ!رն˿ѡٴ!");
                   
                    g_nModeClosePort = MODE_BAUD_CLOSEPORT;
                    
                    goto ret;
				}
                break;

            case CMD_MODIFY_DefBAUD:
				if (nLength < 4)
				{
					goto ret;
				}
				if (m_ArrBuf.GetAt(0) == cByteRetDefBaud[0] &&
					m_ArrBuf.GetAt(1) == cByteRetDefBaud[1] &&
					m_ArrBuf.GetAt(2) == cByteRetDefBaud[2] &&
					m_ArrBuf.GetAt(3) == cByteRetDefBaud[3] )
					
				{
					//
					DeleteCmd();

					m_ArrBuf.RemoveAt(0, 4);
                    
                   
                    Sleep(5);

                    AddCmdToQueue(CMD_RESET);  
                    SendReset();

                    Sleep(100);
                    m_pDlg->ReportInfo("Ĭϲʳɹ!رն˿ѡٴ!");
				    
                    goto ret;
				}
                break;
			case CMD_MODIFY_IMAGE_SIZE:
				if (nLength < 5)
				{
					goto ret;
				}
				if (m_ArrBuf.GetAt(0) == cByteRetImageSize320x240[0] &&
					m_ArrBuf.GetAt(1) == cByteRetImageSize320x240[1] &&
					m_ArrBuf.GetAt(2) == cByteRetImageSize320x240[2] &&
					m_ArrBuf.GetAt(3) == cByteRetImageSize320x240[3] &&
					m_ArrBuf.GetAt(4) == cByteRetImageSize320x240[4])
				{
					//
					DeleteCmd();

					m_ArrBuf.RemoveAt(0, 5);
					m_pDlg->ReportInfo("ͼСɹ!");
                    AddCmdToQueue(CMD_RESET);
                    SendReset();
					goto ret;
				}
				break;

			case CMD_MOTION_SENSITIVITY:
				if (nLength < 5)
				{
					goto ret;
				}
				if (m_ArrBuf.GetAt(0) == cByteRetMotionSensitivity[0] &&
					m_ArrBuf.GetAt(1) == cByteRetMotionSensitivity[1] &&
					m_ArrBuf.GetAt(2) == cByteRetMotionSensitivity[2] &&
					m_ArrBuf.GetAt(3) == cByteRetMotionSensitivity[3] &&
					m_ArrBuf.GetAt(4) == cByteRetMotionSensitivity[4])
				{
					//
					DeleteCmd();
					m_ArrBuf.RemoveAt(0, 5);
					m_pDlg->ReportInfo("ƶȳɹ!");

			    //	Sleep(50);
					
					AddCmdToQueue(CMD_MOTION_OPEN);
					SendMotion(OPEN_MOTION);
					goto ret;
				}
				break;

			case CMD_MOTION_OPEN:
			case CMD_MOTION_CLOSE:
				if (nLength < 5)
				{
					goto ret;
				}
				if (m_ArrBuf.GetAt(0) == cByteRetMotion[0] &&
					m_ArrBuf.GetAt(1) == cByteRetMotion[1] &&
					m_ArrBuf.GetAt(2) == cByteRetMotion[2] &&
					m_ArrBuf.GetAt(3) == cByteRetMotion[3] &&
					m_ArrBuf.GetAt(4) == cByteRetMotion[4])
				{
					if(nCmd == CMD_MOTION_OPEN)
					{
						m_pDlg->ReportInfo("ƶɹ!");
					}
					else if(CMD_MOTION_CLOSE)
					{
						m_pDlg->ReportInfo("رƶɹ!");
					}

					//
					DeleteCmd();

					m_ArrBuf.RemoveAt(0, 5);

					if(m_nMotionStatus == MOTION_DETECTE_INCOMING)
					{
						Sleep(100);
						m_pDlg->TakePhoto();
					}

					
					goto ret;
				}
				break;
			default:
				ASSERT(FALSE);
			}	

			goto ret;
		} //ڴ˷


		if (nCmd == CMD_READ_BUF_512)
		{
			//¼
			UINT nLength = m_ArrBuf.GetSize(); 
			if (nLength <= 0)
			{
				goto ret;
			}

			if (m_bRecvFrameHead == FALSE)
			{
				//֡ͷ־0x76
				BOOL bFind = FALSE;
				int nIndex = -1;
				for (UINT ii = 0; ii < nLength; ++ii)
				{
					if (m_ArrBuf.GetAt(ii) == 0x76)
					{
						nIndex = ii;
						bFind = TRUE;
						break;
					}
				}
				
				if (bFind)
				{
					if (nIndex > 0)
					{
						m_ArrBuf.RemoveAt(0, nIndex);
					}
				}
				else //ȫ
				{
					//ɾЧ
					//,ٴ!
					m_ArrBuf.RemoveAll();
					goto ret;
				}
				
				//¼
				nLength = m_ArrBuf.GetSize(); 
				
				if (nLength < 5)
				{
					goto ret;
				}
				
				if (m_ArrBuf.GetAt(0) == 0x76 &&
					m_ArrBuf.GetAt(1) == g_nSerialNum &&
					m_ArrBuf.GetAt(2) == 0x32 &&
					m_ArrBuf.GetAt(3) == 0x00 && 
					m_ArrBuf.GetAt(4) == 0x00)
				{

					m_ArrBuf.RemoveAt(0, 5);
					
					//֡ͷ 
					m_bRecvFrameHead = TRUE;

					if (m_dwWriteLen == 0)
					{
						//ʼļ
						m_bIsWritingBuf = TRUE;
						m_bFirstFrame = TRUE;

						m_pDlg->CreateWriteFile();
						m_pDlg->ReportInfo("ļ!");
	
					}
					else
					{
						m_pDlg->ReportInfo("512֡ͷ!");
					}

					m_bRecvFrameHead = TRUE;
				}
				else
				{
					//ֻɾһ0x76,һλԶһ0x76
					//ֻ,Ż׳
					m_ArrBuf.RemoveAt(0, 1);
					goto ret;
				}

			}


			if (m_bRecvFrameHead)
			{
				if (m_bFindFrameEnd) 
				{
					BOOL bRecvFrameEnd = FALSE; //յǰ֡֡β

					//¼㳤
					UINT nLength = m_ArrBuf.GetSize();

					//֡β־0x76
					BOOL bFind = FALSE;
					int nIndex = -1;
					for (UINT ii = 0; ii < nLength; ++ii)
					{
						if (m_ArrBuf.GetAt(ii) == 0x76)
						{
							nIndex = ii;
							bFind = TRUE;
							break;
						}
					}
					
					if (bFind)
					{
						if (nIndex > 0)
						{
							m_ArrBuf.RemoveAt(0, nIndex);
						}
					}
					else //ȫ
					{
						//ɾЧ
						//,ٴ!
						m_ArrBuf.RemoveAll();
						goto ret;
					}

					//¼
					nLength = m_ArrBuf.GetSize(); 
					
					if (nLength < 5)
					{
						goto ret;
					}
					
					if (m_ArrBuf.GetAt(0) == 0x76 &&
						m_ArrBuf.GetAt(1) == g_nSerialNum &&
						m_ArrBuf.GetAt(2) == 0x32 &&
						m_ArrBuf.GetAt(3) == 0x00 && 
						m_ArrBuf.GetAt(4) == 0x00)
					{
						
						m_ArrBuf.RemoveAt(0, 5);		
						bRecvFrameEnd = TRUE;

						//һ֡
						ASSERT(m_dwWriteLen > 0);
						if (m_dwWriteLen < m_dwTotalLen &&
							m_dwWriteLen > 0)
						{
							DeleteCmd();
							m_pDlg->ReportInfo("յ512֡β");
							m_pDlg->IndRevJpegData();
						}
						else if (m_dwWriteLen == m_dwTotalLen)
						{

							m_pDlg->ReportInfo("ɾCMD_READ_BUF_512");
							DeleteCmd();

						//	m_pDlg->ReportInfo("յȫ֡֡β");
                            m_pDlg->ReportInfo("յȫ֡ս");
							Sleep(100);

							m_pDlg->PhotoStop();
                        
						}
						else
						{
							ASSERT(FALSE);
						}
						
					}
					else
					{
						//ֻɾһ0x76,һλԶһ0x76
						//ֻ,Ż׳
						m_ArrBuf.RemoveAt(0, 1);
						goto ret;
					}

					if (bRecvFrameEnd)
					{
						
						m_bRecvFrameHead = FALSE;
						m_bFindFrameEnd = FALSE;
					}

					goto ret;
				}

				
				//¼㳤
				UINT nLength = m_ArrBuf.GetSize();

				BYTE szBuf[BLOCK_SIZE];
				
				//һһζ
				if(nLength > 0)
				{
					DWORD dwLeft = m_dwTotalLen - m_dwWriteLen;

					ASSERT(dwLeft >= 0 && dwLeft <= m_dwTotalLen);

					if(dwLeft <= BLOCK_SIZE) //һ
					{
						if (nLength < dwLeft)
						{
							goto ret;
						}
						
						memset(szBuf, 0, BLOCK_SIZE);
						for (DWORD ii = 0; ii < dwLeft; ++ii)
						{
							szBuf[ii] = m_ArrBuf.GetAt(ii);
						}
						
						m_pDlg->WriteBufToFile(szBuf, dwLeft);
						m_ArrBuf.RemoveAt(0, dwLeft);  //ɾ
						
						m_dwWriteLen += dwLeft;	
						
						//֡β 
						m_bFindFrameEnd = TRUE;
					}
					else
					{
						//һд512ֽڸϲ,ʱͷŻ

						if (nLength < BLOCK_SIZE)
						{
							goto ret;
						}

						memset(szBuf, 0, BLOCK_SIZE);
						for (DWORD ii = 0; ii < BLOCK_SIZE; ++ii)
						{
							szBuf[ii] = m_ArrBuf.GetAt(ii);
						}
						
						m_pDlg->WriteBufToFile(szBuf, BLOCK_SIZE);
						m_ArrBuf.RemoveAt(0, BLOCK_SIZE);  //ɾ
						
						m_dwWriteLen += BLOCK_SIZE;

						//֡β 
						m_bFindFrameEnd = TRUE;						
					}

					//nLength = m_ArrBuf.GetSize();  //¼
				}

				goto ret;
			}
		}


		if (nCmd == CMD_READ_BUF_TOTAL)
		{
			
			//¼
			UINT nLength = m_ArrBuf.GetSize(); 
			if (nLength <= 0)
			{
				goto ret;
			}

			if (m_bRecvFrameHead == FALSE)
			{

				//֡ͷ־0x76
				BOOL bFind = FALSE;
				int nIndex = -1;
				for (UINT ii = 0; ii < nLength; ++ii)
				{
					if (m_ArrBuf.GetAt(ii) == 0x76)
					{
						nIndex = ii;
						bFind = TRUE;
						break;
					}
				}
				
				if (bFind)
				{
					if (nIndex > 0)
					{
						m_ArrBuf.RemoveAt(0, nIndex);
					}
				}
				else //ȫ
				{
					//ɾЧ
					//,ٴ!
					m_ArrBuf.RemoveAll();
					goto ret;
				}
				
				//¼
				nLength = m_ArrBuf.GetSize(); 
				
				if (nLength < 5)
				{
					goto ret;
				}
				
				if (m_ArrBuf.GetAt(0) == 0x76 &&
					m_ArrBuf.GetAt(1) == g_nSerialNum &&
					m_ArrBuf.GetAt(2) == 0x32 &&
					m_ArrBuf.GetAt(3) == 0x00 && 
					m_ArrBuf.GetAt(4) == 0x00)
				{
					//ʼļ
					m_bIsWritingBuf = TRUE;
					m_bFirstFrame = TRUE;
					m_ArrBuf.RemoveAt(0, 5);
					
					m_pDlg->CreateWriteFile();
					m_pDlg->ReportInfo("ļ!");
					
					m_bRecvFrameHead = TRUE;
				}
				else
				{
					//ֻɾһ0x76,һλԶһ0x76
					//ֻ,Ż׳
					m_ArrBuf.RemoveAt(0, 1);
					goto ret;
				}

			}


			if (m_bRecvFrameHead)
			{
				m_pDlg->ReportInfo("m_bRecvFrameHead = TRUE");
				if (m_bFindFrameEnd) 
				{
					m_pDlg->ReportInfo("m_bFindFrameEnd = TRUE");
					BOOL bRecvFrameEnd = FALSE; //յǰ֡֡β

					//¼㳤
					UINT nLength = m_ArrBuf.GetSize();

					m_pDlg->ReportInfo("m_bFindFrameEnd = TRUE,֡β־0x76");

					//֡β־0x76
					BOOL bFind = FALSE;
					int nIndex = -1;
					for (UINT ii = 0; ii < nLength; ++ii)
					{
						if (m_ArrBuf.GetAt(ii) == 0x76)
						{
							nIndex = ii;
							bFind = TRUE;
							break;
						}
					}
					
					if (bFind)
					{
						if (nIndex > 0)
						{
							m_ArrBuf.RemoveAt(0, nIndex);
						}
					}
					else //ȫ
					{
						//ɾЧ
						//,ٴ!
						m_ArrBuf.RemoveAll();
						goto ret;
					}

					//¼
					nLength = m_ArrBuf.GetSize(); 
					
					if (nLength < 5)
					{
						goto ret;
					}
					
					m_pDlg->ReportInfo("ȴ֡β76 00 32 00 00");
					if (m_ArrBuf.GetAt(0) == 0x76 &&
						m_ArrBuf.GetAt(1) == g_nSerialNum &&
						m_ArrBuf.GetAt(2) == 0x32 &&
						m_ArrBuf.GetAt(3) == 0x00 && 
						m_ArrBuf.GetAt(4) == 0x00)
					{
////						AfxMessageBox("յ֡β76 00 32 00 00");
						m_pDlg->ReportInfo("ɹ:ȴ֡β76 00 32 00 00");

						m_ArrBuf.RemoveAt(0, 5);		
						bRecvFrameEnd = TRUE;

						
						m_bRecvFrameHead = FALSE;
						m_bFindFrameEnd = FALSE;

						DeleteCmd();
						m_pDlg->ReportInfo("ɾCMD_READ_TOTAL");

						m_pDlg->ReportInfo("յļ־");

						Sleep(100);

						m_pDlg->PhotoStop();
                        
					}
					else
					{
						//ֻɾһ0x76,һλԶһ0x76
						//ֻ,Ż׳
						m_ArrBuf.RemoveAt(0, 1);
						goto ret;
					}

					if (bRecvFrameEnd)
					{
						//m_pDlg->ReportInfo("m_bRecvFrameHeadm_bFindFrameEndΪFALSE");
                        m_pDlg->ReportInfo("ս!");
						m_bRecvFrameHead = FALSE;
						m_bFindFrameEnd = FALSE;
					}

					goto ret;
				}
				else
				{
					m_pDlg->ReportInfo("m_bFindFrameEnd = FALSE");
				}
				
				//¼㳤
				UINT nLength = m_ArrBuf.GetSize();


				BYTE szBuf[BLOCK_SIZE];
				

				while(nLength > 0)
				{
					

					DWORD dwLeft = m_dwTotalLen - m_dwWriteLen;

//					ASSERT(dwLeft >= 0 && dwLeft <= m_dwTotalLen);

					if(dwLeft >= 0 && dwLeft <= BLOCK_SIZE) //һ
					{
						m_pDlg->ReportInfo("һ");
						if (dwLeft == 0 || nLength < dwLeft)
						{
							goto ret;
						}
						
						
						memset(szBuf, 0, BLOCK_SIZE);
						for (DWORD ii = 0; ii < dwLeft; ++ii)
						{
							szBuf[ii] = m_ArrBuf.GetAt(ii);
						}
						
						m_pDlg->WriteBufToFile(szBuf, dwLeft);
						m_ArrBuf.RemoveAt(0, dwLeft);  //ɾ
						
						m_dwWriteLen += dwLeft;	
						
						m_pDlg->ReportInfo("m_bFindFrameEnd = TRUE");
						//֡β 
						m_bFindFrameEnd = TRUE;
					}
					else
					{
						//һд512ֽڸϲ,ʱͷŻ

						if (nLength < BLOCK_SIZE)
						{
							goto ret;
						}

						m_pDlg->ReportInfo("һд512ֽڸϲ,ʱͷŻ");

						memset(szBuf, 0, BLOCK_SIZE);
						for (DWORD ii = 0; ii < BLOCK_SIZE; ++ii)
						{
							szBuf[ii] = m_ArrBuf.GetAt(ii);
						}
						
						m_pDlg->WriteBufToFile(szBuf, BLOCK_SIZE);
						m_ArrBuf.RemoveAt(0, BLOCK_SIZE);  //ɾ
						
						m_dwWriteLen += BLOCK_SIZE;
						
					}

					nLength = m_ArrBuf.GetSize();  //¼
				}

				goto ret;
			}
		}
		


	}
	else
	{
		int nLength = m_ArrBuf.GetSize(); 
		
		if (nLength <= 0)
		{
			goto ret;
		}

		//MotionDetected {76 00 39 00 00}
		if(nLength < 5)
		{
			goto ret;	
		}
		else
		{
			//Ƿƶ⴮
			
			if (m_ArrBuf.GetAt(0) == cByteMotionDetected[0] &&
					m_ArrBuf.GetAt(1) == g_nSerialNum &&
					m_ArrBuf.GetAt(2) == cByteMotionDetected[2] &&
					m_ArrBuf.GetAt(3) == cByteMotionDetected[3] &&
					m_ArrBuf.GetAt(4) == cByteMotionDetected[4])
			{
				
				m_ArrBuf.RemoveAll();
				m_pDlg->ReportInfo("⵽ƶ!");
			/*	if (AfxMessageBox("ƶⱨ棡") == IDOK )
				{
					
				//	m_pDlg->TakePhoto();
				}
			*/
				m_nMotionStatus = MOTION_DETECTE_INCOMING;

				Sleep(100);
				
				AddCmdToQueue(CMD_MOTION_CLOSE);
				SendMotion(CLOSE_MOTION);
                goto ret;
			}
			
		}
		
		if (nLength < nSizeRetOnPower)
		{
			goto ret;
		}

		//ж󼸸ֽ49 6E 69 74 20 65 6E 64 0D 0A Ϳ
		BOOL bFind = FALSE;
		int nIndex = -1;
		int ii = 0;
		for (ii = 0; ii < nLength-1; ++ii)
		{
			if (m_ArrBuf.GetAt(ii) == 0x49 && 
				m_ArrBuf.GetAt(ii+1) == 0x6E)
			{
				nIndex = ii;
				bFind = TRUE;
				break;
			}
		}
		
		if (bFind)
		{
			if (nIndex > 0)
			{
				m_ArrBuf.RemoveAt(0, nIndex);
			}
		}
		else //ȫ
		{
		    			
			//ɾЧ
			//,ٴ!
			m_ArrBuf.RemoveAll();
			goto ret;	
		
			
		}

		//¼
		nLength = m_ArrBuf.GetSize(); 
		if (nLength < nSizeRetOnPower)
		{
			goto ret;
		}

		//жǷϵ
		for (ii = 0; ii < nSizeRetOnPower; ++ii)
		{
			if (m_ArrBuf.GetAt(ii) != cByteRetOnPower[ii])
			{
				break;
			}
		}

		if (ii == nSizeRetOnPower)
		{
			m_pDlg->ReportInfo("ϵɹ!յInit end!");
			m_ArrBuf.RemoveAt(0, nSizeRetOnPower);
			
		}
		else
		{
		//	m_pDlg->ReportInfo("ϵյδַ֪,սջ!");
			m_ArrBuf.RemoveAll();
		}

	}

ret:
	LeaveCriticalSection(&m_csBuf);
	return;
}

void CGxtY601::Reset()
{
	EnterCriticalSection(&m_csBuf);
	m_ArrBuf.RemoveAll();
	LeaveCriticalSection(&m_csBuf);
	m_dwWriteLen = 0;
	m_dwTotalLen = 0;
	m_bWaitLastFrame = FALSE;
	m_bIsWritingBuf = FALSE;
}

void CGxtY601::SetSerialNum()
{

	cByteReset[ID_SERIAL_NUM] = g_nSerialNum;
	cBytePhoto[ID_SERIAL_NUM] = g_nSerialNum;
	cByteReadLength[ID_SERIAL_NUM] = g_nSerialNum;
	cByteReadBuf[ID_SERIAL_NUM] = g_nSerialNum;
	cByteStopPhoto[ID_SERIAL_NUM] = g_nSerialNum;
	cByteZipRate[ID_SERIAL_NUM] = g_nSerialNum;
	cByteImageSize160x120[ID_SERIAL_NUM] = g_nSerialNum;
	cByteImageSize320x240[ID_SERIAL_NUM] = g_nSerialNum;
	cByteImageSize640x480[ID_SERIAL_NUM] = g_nSerialNum;
	cByteSavePower[ID_SERIAL_NUM] = g_nSerialNum;
	cByteExitSavePower[ID_SERIAL_NUM] = g_nSerialNum;
	cByteBaud9600[ID_SERIAL_NUM] = g_nSerialNum;
	cByteBaud19200[ID_SERIAL_NUM] = g_nSerialNum;
	cByteBaud38400[ID_SERIAL_NUM] = g_nSerialNum;
	cByteBaud57600[ID_SERIAL_NUM] = g_nSerialNum;
	cByteBaud115200[ID_SERIAL_NUM] = g_nSerialNum;
    cByteDefBaud9600[ID_SERIAL_NUM] = g_nSerialNum;
	cByteDefBaud19200[ID_SERIAL_NUM] = g_nSerialNum;
	cByteDefBaud38400[ID_SERIAL_NUM] = g_nSerialNum;
	cByteDefBaud57600[ID_SERIAL_NUM] = g_nSerialNum;
	cByteDefBaud115200[ID_SERIAL_NUM] = g_nSerialNum;
	cByteMotionOpen[ID_SERIAL_NUM] = g_nSerialNum;
	cByteMotionClose[ID_SERIAL_NUM] = g_nSerialNum;
	cByteMotionSensitivity[ID_SERIAL_NUM] = g_nSerialNum;

	cByteRetReset[ID_SERIAL_NUM] = g_nSerialNum;
	cByteRetPhoto[ID_SERIAL_NUM] = g_nSerialNum;
	cByteRetReadLength[ID_SERIAL_NUM] = g_nSerialNum;
	cByteRetZipRate[ID_SERIAL_NUM] = g_nSerialNum;
	cByteRetSavePower[ID_SERIAL_NUM] = g_nSerialNum;
	cByteRetImageSize160x120[ID_SERIAL_NUM] = g_nSerialNum;
	cByteRetImageSize320x240[ID_SERIAL_NUM] = g_nSerialNum;
	cByteRetImageSize640x480[ID_SERIAL_NUM] = g_nSerialNum;
	cByteRetBaud[ID_SERIAL_NUM]  = g_nSerialNum;
	cByteRetDefBaud[ID_SERIAL_NUM]  = g_nSerialNum;
	cByteRetMotion[ID_SERIAL_NUM]  = g_nSerialNum;
	cByteRetMotionSensitivity[ID_SERIAL_NUM]  = g_nSerialNum;

}

//Ϣ,Ϣпط
void CGxtY601::AddCmdToQueue(int nCmd)
{
	ASSERT(nCmd != CMD_INVALID);

	EnterCriticalSection(&m_csCmdQueue);
	m_ArrCmdQueue.Add(nCmd);
	LeaveCriticalSection(&m_csCmdQueue);

}

//ͷ
int  CGxtY601::QueryCmd()
{
	int nRet = CMD_INVALID;

	EnterCriticalSection(&m_csCmdQueue);
	if (m_ArrCmdQueue.GetSize() < 1)
	{
		nRet = CMD_INVALID;
	}
	else
	{	
		nRet = m_ArrCmdQueue.GetAt(0);
	}
	LeaveCriticalSection(&m_csCmdQueue);

	return nRet;
}

void  CGxtY601::DeleteAllCmd()
{
	EnterCriticalSection(&m_csCmdQueue);
	
	m_ArrCmdQueue.RemoveAll();

	LeaveCriticalSection(&m_csCmdQueue);
}

void  CGxtY601::DeleteCmd()
{
	EnterCriticalSection(&m_csCmdQueue);
	if (m_ArrCmdQueue.GetSize() > 0)
	{	
		m_ArrCmdQueue.RemoveAt(0);
	}
	LeaveCriticalSection(&m_csCmdQueue);
}

BOOL  CGxtY601::IsCmdEmpty()
{
	BOOL bEmpty;
	EnterCriticalSection(&m_csCmdQueue);
	bEmpty = (m_ArrCmdQueue.GetSize() == 0);
	if (m_ArrCmdQueue.GetSize() > 0)
	{	
		m_ArrCmdQueue.RemoveAt(0);
	}
	LeaveCriticalSection(&m_csCmdQueue);
	return bEmpty;
}

